"use client";

import { useSearchParams } from "next/navigation";
import { useState } from "react";

export default function VerifyOtpClient() {
  const searchParams = useSearchParams();
  const phone = searchParams.get("phone");

  const [code, setCode] = useState("");

  return (
    <div className="max-w-md mx-auto p-6 bg-white border rounded-xl">
      <h1 className="text-xl font-bold mb-2">Vérification OTP</h1>
      <p className="text-sm text-gray-600 mb-4">
        Code envoyé au : <strong>{phone}</strong>
      </p>

      <input
        className="w-full border rounded-lg p-2 mb-3"
        placeholder="Code OTP"
        value={code}
        onChange={(e) => setCode(e.target.value)}
      />

      <button className="w-full bg-blue-600 text-white rounded-lg py-2">
        Vérifier
      </button>
    </div>
  );
}
