import Card from "@/components/Card";
import { getServerSession } from "next-auth";
import { authOptions } from "@/lib/auth";
import Link from "next/link";
import { redirect } from "next/navigation";

export default async function Dashboard() {
  const session = await getServerSession(authOptions);
  if (!session) redirect("/login");

  const role = (session as any).user.role as string;

  return (
    <Card>
      <h1 className="text-2xl font-bold mb-2">Dashboard</h1>
      <p className="text-gray-600 mb-4">Connecté en tant que <span className="font-semibold">{role}</span></p>

      <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3">
        <Link className="border rounded-lg p-4 hover:bg-gray-50" href="/properties">🏠 Biens</Link>
        <Link className="border rounded-lg p-4 hover:bg-gray-50" href="/agencies">🏢 Agences</Link>
        <Link className="border rounded-lg p-4 hover:bg-gray-50" href="/services">👷 Prestataires</Link>
        <Link className="border rounded-lg p-4 hover:bg-gray-50" href="/orders">🛒 Commandes</Link>
      </div>

      <div className="mt-6 text-sm text-gray-600">
        <p>Astuce : le rôle admin peut tout gérer. Les autres rôles ont accès basique (à améliorer).</p>
      </div>
    </Card>
  );
}
