"use client";

import { signIn } from "next-auth/react";
import { useState } from "react";
import Link from "next/link";

export default function LoginPage() {
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [error, setError] = useState<string | null>(null);
  const [loading, setLoading] = useState(false);

  async function onSubmit(e: React.FormEvent) {
    e.preventDefault();
    setError(null);
    setLoading(true);

    const res = await signIn("credentials", {
      email,
      password,
      redirect: false,
    });

    setLoading(false);

    if (!res?.ok) {
      setError("Email ou mot de passe incorrect");
      return;
    }

    window.location.href = "/dashboard";
  }

  return (
    <div className="max-w-md mx-auto bg-white border rounded-xl p-6">
      <h1 className="text-2xl font-bold mb-2">Connexion</h1>
      <p className="text-sm text-gray-600 mb-6">Connecte-toi pour accéder au dashboard.</p>

      {error && <div className="mb-4 p-3 rounded bg-red-50 text-red-700 text-sm">{error}</div>}

      <form onSubmit={onSubmit} className="space-y-4">
        <div>
          <label className="block text-sm font-medium mb-1">Email</label>
          <input className="w-full border rounded-lg p-2" value={email} onChange={(e) => setEmail(e.target.value)} type="email" required />
        </div>
        <div>
          <label className="block text-sm font-medium mb-1">Mot de passe</label>
          <input className="w-full border rounded-lg p-2" value={password} onChange={(e) => setPassword(e.target.value)} type="password" required />
        </div>
        <button disabled={loading} className="w-full bg-blue-600 text-white rounded-lg py-2 hover:bg-blue-700 disabled:opacity-60">
          {loading ? "Connexion..." : "Se connecter"}
        </button>
      </form>

      <p className="text-sm text-gray-600 mt-4">
        Pas de compte ? <Link className="text-blue-600 hover:underline" href="/register">Créer un compte</Link>
      </p>

      <div className="mt-6 text-xs text-gray-500">
        <p className="font-semibold mb-1">Comptes démo (après seed)</p>
        <p>admin@demo.com / Admin12345</p>
        <p>agence@demo.com / Agence12345</p>
        <p>prestataire@demo.com / Prest12345</p>
        <p>client@demo.com / Client12345</p>
      </div>
    </div>
  );
}
